//-----------------------------LICENSE NOTICE------------------------------------
//  This file is part of Outlaws
//  Copyright (C) 2016 RETROBYTES PRODUCTIONS
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------

#ifndef _DEFINES_H_
#define _DEFINES_H_

//Levels

#define MAX_LEVELS 9
#define MAX_RESPAWNS 4
#define MAX_LIVES 4

#define TRUE  1
#define FALSE 0

// Pointer to the video buffer and back buffer
#define SCR_VMEM (u8*)0xC000
#define SCR_BUFF (u8*)0x8000

//Screen Sizes
#define MIN_X  0
#define MIN_Y  0
#define MAX_X  79
#define MAX_Y  128

//HUD
#define HUD_H 64
#define HUD_W 58

#define HUD2_H 64
#define HUD2_W 22


//Sprites Size
#define FONT_H 8
#define FONT_W 3

//HUD NUMBERS
#define MARCADOR_H 8
#define MARCADOR_W 2


//HERO
#define HERO_H 32
#define HERO_W  8

#define HERO_STATE_ON_FLOOR      0
#define HERO_STATE_GOING_LEFT    1
#define HERO_STATE_GOING_RIGHT   2
#define HERO_STATE_FIRING		 3
#define HERO_STATE_HIT			 4
#define HERO_STATE_DEAD			 5

#define MAX_BULLETS 	         10
#define BULLET_H            4
#define BULLET_W            2

#define HERO_FLOOR_Y MAX_Y - HERO_H

//TARGET
#define TARGET_H  11
#define TARGET_W  5

//ENEMIES
#define ENEMY_TYPE_BARREL 20
#define ENEMY_BARREL_H 20
#define ENEMY_BARREL_W 5
#define ENEMY_BARREL_X_SPEED 0

#define ENEMY_TYPE_CACTUS 21
#define ENEMY_CACTUS_H 24
#define ENEMY_CACTUS_W 7
#define ENEMY_CACTUS_X_SPEED 0

#define ENEMY_TYPE_MUROMADERA 22
#define ENEMY_MUROMADERA_H 16
#define ENEMY_MUROMADERA_W 8
#define ENEMY_MUROMADERA_X_SPEED 0

#define ENEMY_TYPE_MUROPIEDRA 23
#define ENEMY_MUROPIEDRA_H 16
#define ENEMY_MUROPIEDRA_W 8
#define ENEMY_MUROPIEDRA_X_SPEED 0

#define ENEMY_TYPE_MURO 24
#define ENEMY_MURO_H 16
#define ENEMY_MURO_W 8
#define ENEMY_MURO_X_SPEED 0

#define ENEMY_TYPE_COKE 25
#define ENEMY_COKE_H 14
#define ENEMY_COKE_W 3
#define ENEMY_COKE_X_SPEED 0

#define ENEMY_TYPE_MONEY 26
#define ENEMY_MONEY_H 11
#define ENEMY_MONEY_W 5
#define ENEMY_MONEY_X_SPEED 0


#define ENEMY_TYPE_BOTTLE 27
#define ENEMY_BOTTLE_H 13
#define ENEMY_BOTTLE_W 3
#define ENEMY_BOTTLE_X_SPEED 0


#define ENEMY_TYPE_WINDOW 28
#define ENEMY_WINDOW_H 20
#define ENEMY_WINDOW_W 5
#define ENEMY_WINDOW_X_SPEED 0

#define ENEMY_TYPE_LEJOS 29
#define ENEMY_LEJOS_H 20
#define ENEMY_LEJOS_W 6
#define ENEMY_LEJOS_X_SPEED 2

#define ENEMY_TYPE_CERCA 30
#define ENEMY_CERCA_H 29
#define ENEMY_CERCA_W 8
#define ENEMY_CERCA_X_SPEED 3

#define MAX_ENEMIES 5
#define MAX_WINDOW_ENEMIES 3

#define ENEMY_STATE_INACTIVE     0
#define ENEMY_STATE_ACTIVE       1
#define ENEMY_STATE_FIRE         2
#define ENEMY_STATE_EXPLOSION_A  3
#define ENEMY_STATE_EXPLOSION_B  4
#define ENEMY_STATE_EXPLOSION_C  5

//EXPLOSION
#define EXPLOSION_H 19
#define EXPLOSION_W  4

//MOUNTAINS
#define MOUNTAIN1_H 50
#define MOUNTAIN1_W 17
#define MOUNTAIN2_H 34
#define MOUNTAIN2_W 18

/////////////////////////////////////////////////

#endif
